﻿using MyFirstApp.Server.Repositories;
using MyFirstApp.Shared;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace MyFirstApp.Server.Services
{
    public class UserService
    {
        private IUserRepository _userRepository;
        private IEnumerable<User> _users;

        public UserService(IUserRepository userRepository)
        {
            _userRepository = userRepository;
        }

        public async Task<IEnumerable<User>> Get()
        {
            _users =  await _userRepository.Get();
            return _users;
        }

        public async Task<string> Delete(string id)
        {
            string idTemp = string.Empty;
            if (!string.IsNullOrEmpty(id))
            {
                idTemp = await _userRepository.Delete(id);
            }

            return idTemp;
        }

        public async Task Update(User userTemp)
        {
            if (userTemp != null)
            {
                await _userRepository.Update(userTemp);
            }            
        }
    }
}
